import { ControlServiceBase, ControlVOBase, hasFunction } from '@core';

/**
 * 表单部件服务
 *
 * @export
 * @class EditFormService
 * @template T 部件数据对象类型
 */
export class EditFormService<T extends ControlVOBase> extends ControlServiceBase<T> {
  /**
   * 加载草稿数据
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async loadDraft(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    // todo主键
    const action = hasFunction(_entityService, opts.action) ? opts.action : 'GetDraft';
    const response = await _entityService[action](Context, Data, opts.isLoading);
    // this.setRemoteCopyData(response);
    response.data = this.newControlVO(response.data);
    response.data.srfuf = '0';
    return this.handleResponse(response, opts);
  }

  /**
   * 加载数据
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async get(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    const action = hasFunction(_entityService, opts.action) ? opts.action : 'GET';
    const response = await _entityService[action](Context, Data, opts.isLoading);
    // this.setRemoteCopyData(response);
    response.data = this.newControlVO(response.data);
    return this.handleResponse(response, opts);
  }

  /**
   * 创建数据
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async create(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    const action = hasFunction(_entityService, opts.action) ? opts.action : 'Create';
    const response = await _entityService[action](Context, Data, opts.isLoading);
    response.data = this.newControlVO(response.data);
    return this.handleResponse(response, opts);
  }

  /**
   * 删除数据
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async remove(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    const action = hasFunction(_entityService, opts.action) ? opts.action : 'Remove';
    const response = await _entityService[action](Context, Data, opts.isLoading);
    response.data = this.newControlVO(response.data);
    return this.handleResponse(response, opts);
  }

  /**
   * 更新数据
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async update(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    const action = hasFunction(_entityService, opts.action) ? opts.action : 'Update';
    const response = await _entityService[action](Context, Data, opts.isLoading);
    response.data = this.newControlVO(response.data);
    return this.handleResponse(response, opts);
  }

  /**
   * 前台逻辑
   *
   * @param [context={}] 上下文参数
   * @param [data={}] 视图参数
   * @param opts
   * @return {*}
   */
  public async frontLogic(context: any, data: any, opts: { action: string; isLoading?: boolean }): Promise<any> {
    let _entityService: any = this.entityService;
    const { context: Context, data: Data } = this.handleRequestData(context, data, opts);
    if (hasFunction(_entityService, opts.action)) {
      const response = await _entityService[opts.action](Context, Data, opts.isLoading);
      response.data = this.newControlVO(response.data);
      return this.handleResponse(response, opts);
    } else {
      return 
    }
  }

  /**
   * @description 获取远端数据
   * @return {*} 
   * @memberof EditFormService
   */
  public getRemoteCopyData() {
    // return this.remoteCopyData;
  }

  /**
   * 获取跨实体数据集合
   *
   * @param {string} entityKey 实体标识
   * @param {string} interfaceName 行为标识
   * @param {*} [context={}] 应用上下文
   * @param {*} [data={}] 参数
   * @return {*}  {Promise<any>}
   * @memberof EditFormService
   */
  getItems(entityKey: string, interfaceName: string, context: any = {}, data: any = {}): Promise<any> {
    return new Promise((resolve: any, reject: any) => {
      App.getDataService(entityKey.toLowerCase(), context).then((service: any) => {
        if (service && hasFunction(service, interfaceName)) {
          resolve(this.doItems(service[interfaceName](context, data), service.appEntityKeyCodeName, service.appEntityCodeName));
        } else {
          resolve([]);
        }
      }).catch((error: any) => {
        resolve([]);
      });
    })
  }

  /**
   * 处理跨实体数据
   *
   * @param {Promise<any>} promise
   * @param {string} deKeyField 实体主键
   * @param {string} deName 实体标识
   * @return {*} 
   * @memberof EditFormService
   */
  doItems(promise: Promise<any>, deKeyField: string, deName: string) {
    return new Promise((resolve: any, reject: any) => {
      promise.then((response: any) => {
        if (response && response.status === 200) {
          const items: any[] = [];
          response.data.forEach((item: any) => {
            item = this.newControlVO(item);
            item[deName] = item[deKeyField];
            items.push(item);
          });
          resolve(items);
        } else {
          resolve([]);
        }
      }).catch((error: any) => {
        resolve([]);
      });
    });
  }
}
